#include <iostream>
#include <cstring>
#include <cstdio>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
using namespace std;

typedef pair<int, int> ii;
typedef vector<int> vi;
typedef vector<vi> vvi;
typedef vector<ii> vii;

template <class T> int size(const T &x) { return x.size(); }

int mncut[100][100];
int mnedge[100][100];

const int INF = 2147483647;

struct union_find {
    vi p;
    union_find(int n) {
        p = vi(n);
        for (int i = 0; i < n; i++) {
            p[i] = i;
        }
    }

    int find(int x) {
        return p[x] == x ? x : p[x] = find(p[x]);
    }

    void unite(int x, int y) {
        p[find(x)] = find(y);
    }
};

int main() {

    int n;
    scanf("%d\n", &n);

    vector<pair<int, ii> > edges;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            int x;
            scanf("%d", &x);
            mncut[i][j] = x;

            if (i < j) {
                edges.push_back(make_pair(mncut[i][j], ii(i, j)));
            }
        }
    }

    sort(edges.rbegin(), edges.rend());

    union_find uf(n);

    vector<pair<ii, int> > res;

    vii *adj = new vii[n];

    for (int i = 0; i < size(edges); i++) {
        int cap = edges[i].first;
        int a = edges[i].second.first,
            b = edges[i].second.second;

        if (uf.find(a) != uf.find(b)) {
            res.push_back(make_pair(ii(a, b), cap));
            uf.unite(a, b);
            adj[a].push_back(ii(b, cap));
            adj[b].push_back(ii(a, cap));
        }
    }

    for (int i = 0; i < n; i++) {
        vector<bool> visited(n, false);
        visited[i] = true;
        stack<int> S;
        S.push(i);
        mnedge[i][i] = INF;

        while (!S.empty()) {
            int cur = S.top();
            S.pop();

            for (int j = 0; j < size(adj[cur]); j++) {
                int nxt = adj[cur][j].first;
                int len = adj[cur][j].second;

                if (!visited[nxt]) {
                    visited[nxt] = true;
                    S.push(nxt);
                    mnedge[i][nxt] = min(len, mnedge[i][cur]);
                }
            }
        }

        mnedge[i][i] = 0;
    }

    bool ok = true;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            ok = ok && mnedge[i][j] == mncut[i][j];
            //printf("%d ", mnedge[i][j]);
        }

        //printf("\n");
    }

    if (!ok) {
        printf("NO\n");
    } else {
        printf("YES\n");
        for (int i = 0; i < size(res); i++) {
            printf("%d %d %d\n", res[i].first.first + 1, res[i].first.second + 1, res[i].second);
        }
    }

    return 0;
}
